<?php
session_start(); // Start session

if(!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true){
    header("Location: index.php"); // Redirect to login if not logged in
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=no">
  <title>[𝐉𝐀𝐂𝐊 𝐏𝐑𝐄𝐌𝐈𝐔𝐌 𝐀𝐏𝐈💀] Trading Dashboard</title>
  <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;700&family=Orbitron:wght@700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
:root {
  --bg-primary: #10141C;
  --bg-secondary: #191F2C;
  --border-color: #333A4C;
  --text-primary: #F0F2F5;
  --text-secondary: #7A8299;
  --aura-gold: #FFC700;
  --aura-teal: #00F5D4;
  --aura-red: #FF4D4D;
  --font-primary: 'DM Sans', sans-serif;
  --font-display: 'Orbitron', sans-serif;
}

/* Default */
* { box-sizing: border-box; margin: 0; padding: 0; }
body {
  font-family: var(--font-primary);
  color: var(--text-primary);
  background: radial-gradient(circle at top, #161c27, #0c0f14 80%);
  padding: 1rem;
  min-height: 100vh;
  overflow-x: hidden;
}
.app-container { 
  max-width: 700px; 
  margin: 0 auto; 
  animation: fadeIn 1s ease-in-out;
}

/* Fade animation */
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(10px); }
  to { opacity: 1; transform: translateY(0); }
}

/* Header */
.header {
  display: flex; justify-content: center; align-items: center;
  margin-bottom: 1.5rem; padding-bottom: 1rem;
  border-bottom: 1px solid var(--border-color);
  text-align: center;
  animation: neonGlow 2s infinite alternate;
}

@keyframes neonGlow {
  from { box-shadow: 0 0 0px var(--aura-gold); }
  to { box-shadow: 0 0 14px var(--aura-gold); }
}

.header-logo { display: flex; align-items: center; gap: 0.7rem; }
.header-logo i {
  font-size: 1.6rem;
  background: linear-gradient(45deg, var(--aura-gold), var(--aura-teal));
  -webkit-background-clip: text; -webkit-text-fill-color: transparent;
  animation: spin 3s linear infinite;
}
@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
.header-logo h1 {
  font-family: var(--font-display);
  font-size: 1.2rem;
  color: var(--aura-gold);
  animation: textShine 2s infinite alternate;
}
@keyframes textShine {
  from { text-shadow: 0 0 0px var(--aura-gold); }
  to { text-shadow: 0 0 10px var(--aura-gold); }
}

/* Cards */
.card {
  background-color: var(--bg-secondary);
  border: 1px solid var(--border-color);
  border-radius: 12px;
  padding: 1.5rem;
  position: relative;
  overflow: hidden;
  text-align: center;
  margin-bottom: 1.5rem;
  transition: 0.4s;
}
.card:hover {
  transform: translateY(-4px);
  box-shadow: 0 0 12px var(--aura-teal);
}

/* Top glow line */
.card::before {
  content: '';
  position: absolute; top: 0; left: 0; right: 0;
  height: 2px;
  background: linear-gradient(90deg, transparent, var(--aura-gold), transparent);
  animation: scan 6s linear infinite;
}
@keyframes scan { 0% { transform: translateX(-100%);} 100% {transform: translateX(100%);} }

/* Running Signal */
.running-signal {
  font-size: 1rem;
  font-weight: 500;
  color: var(--aura-teal);
  margin-bottom: 0.5rem;
  text-shadow: 0 0 8px var(--aura-teal);
  animation: glowPulse 2s infinite;
}
@keyframes glowPulse {
  0% { opacity: 0.7; }
  100% { opacity: 1; text-shadow: 0 0 15px var(--aura-teal); }
}

/* Signal text BIG / SMALL */
.signal-text {
  font-size: 2rem;
  font-weight: bold;
  margin-top: 0.5rem;
  animation: beat 1.2s infinite ease-in-out;
}
@keyframes beat {
  0% { transform: scale(1); }
  50% { transform: scale(1.12); }
  100% { transform: scale(1); }
}
.signal-big { color: var(--aura-red); text-shadow: 0 0 12px var(--aura-red); }
.signal-small { color: var(--aura-teal); text-shadow: 0 0 12px var(--aura-teal); }

/* Timer */
.timer-container { margin-top: 1.5rem; position: relative; width: 140px; height: 140px; margin-left: auto; margin-right: auto; }
.timer-ring { transform: rotate(-90deg); filter: drop-shadow(0 0 6px var(--aura-gold)); }
.timer-ring__background { stroke: var(--border-color); fill: transparent; stroke-width: 6; }
.timer-ring__progress {
  stroke: var(--aura-gold); fill: transparent; stroke-width: 6;
  stroke-linecap: round; transition: stroke-dashoffset 1s linear;
  filter: drop-shadow(0 0 4px var(--aura-gold));
}
.timer-text {
  position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);
  font-family: var(--font-display); font-size: 2rem; color: var(--aura-gold);
}

/* Table */
table {
  width: 100%;
  border-collapse: collapse;
  margin-top: 1rem;
  font-size: 0.8rem;
  animation: fadeIn 1s ease-in-out;
}
tbody tr {
  animation: slideIn 0.7s ease;
}
@keyframes slideIn {
  from { opacity: 0; transform: translateX(-10px); }
  to { opacity: 1; transform: translateX(0); }
}

th, td {
  padding: 6px;
  text-align: center;
  border-bottom: 1px solid var(--border-color);
}
th { color: var(--aura-gold); font-weight: 600; }
.big { color: var(--aura-red); font-weight: bold; }
.small { color: var(--aura-teal); font-weight: bold; }

.footer { text-align: center; margin-top: 2rem; color: var(--text-secondary); font-size: 0.8rem; }
</style>
</head>
<body>
  <div class="app-container">
    <header class="header">
      <div class="header-logo">
        <i class="fas fa-chart-line"></i>
        <h1>[𝐉𝐀𝐂𝐊 𝐏𝐑𝐄𝐌𝐈𝐔𝐌 𝐀𝐏𝐈💀] 𝐎𝐟𝐟𝐢𝐜𝐢𝐚𝐥</h1>
      </div>
    </header>

<main>
  <section class="card">
    <div id="running-signal" class="running-signal">Running Now: --</div>
    <h2> Current Period: <span id="period">--</span></h2>
    <div id="signal" class="signal-text">Loading...</div>

    <!-- Timer -->
    <div class="timer-container">
      <svg class="timer-ring" width="140" height="140">
        <circle class="timer-ring__background" r="64" cx="70" cy="70" />
        <circle class="timer-ring__progress" r="64" cx="70" cy="70" />
      </svg>
      <div class="timer-text" id="countdown">--</div>
    </div>

    <!-- ⭐ Chance Box -->
    <div id="chance-box" class="chance-box">Chance: --%</div>

    <!-- 📲 Animated Telegram Contact Box -->
    <div class="telegram-box">
      <a href="https://t.me/C_W_owner" target="_blank">
        <img src="https://upload.wikimedia.org/wikipedia/commons/8/82/Telegram_logo.svg" alt="Telegram Logo" class="telegram-logo">
        Telegram Contact
      </a>
    </div>

    <!-- 🎮 Two Buttons Side by Side -->
    <div class="game-buttons">
      <!-- DKWIN -->
      <a href="https://dkwin9.com/#/register?invitationCode=78281994506" target="_blank" class="game-btn">
        <img src="https://i.postimg.cc/W3KdGfkG/dk-win-games-logo.avif" alt="DKWIN Logo" class="game-logo">
        DKWIN
      </a>

      <!-- HGNICE -->
      <a href="https://hgnice.site/#/register?invitationCode=47434745469" target="_blank" class="game-btn">
        <img src="https://i.postimg.cc/0yqtv9N6/c5cd424d-8512-4f21-b519-566ea44fa538.jpg" alt="HGNICE Logo" class="game-logo">
        HGNICE
      </a>
    </div>
  </section>
</main>

<style>
  /* Chance Box */
  .chance-box {
    margin-top: 12px;
    padding: 10px 20px;
    font-size: 24px;
    font-weight: bold;
    text-align: center;
    color: #fff;
    border-radius: 10px;
    background: rgba(0, 255, 150, 0.15);
    border: 1px solid rgba(0, 255, 150, 0.3);
    box-shadow: 0 0 12px rgba(0, 255, 170, 0.7);
  }

  /* Telegram Box */
  .telegram-box {
    margin-top: 20px;
    text-align: center;
  }

  .telegram-box a {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 12px 20px;
    font-size: 20px;
    font-weight: bold;
    color: #fff;
    background-color: #0088cc;
    border-radius: 12px;
    text-decoration: none;
    box-shadow: 0 0 15px #00aaff;
    animation: pulse 2s infinite;
    transition: 0.3s;
  }

  .telegram-box a:hover {
    transform: scale(1.05);
    box-shadow: 0 0 25px #00ffff, 0 0 50px #00aaff;
  }

  .telegram-logo {
    width: 28px;
    height: 28px;
  }

/* Game Buttons Container */
.game-buttons {
  margin-top: 20px;
  display: flex;
  justify-content: center;
  gap: 20px;
  flex-wrap: wrap;
}

.game-btn {
  display: flex;
  align-items: center;
  gap: 8px; /* gap komano */
  padding: 8px 16px; /* padding komano */
  font-size: 16px; /* font-size komano */
  font-weight: bold;
  color: #fff;
  background-color: #ff6600;
  border-radius: 10px; /* border-radius halka komano */
  text-decoration: none;
  box-shadow: 0 0 10px #ff9933; /* shadow halka komano */
  transition: 0.3s;
  animation: pulse 2s infinite;
}

.game-btn:hover {
  transform: scale(1.05);
  box-shadow: 0 0 20px #ffcc66, 0 0 40px #ff9933; /* hover shadow adjust kora */
}

.game-logo {
  width: 22px; /* logo size komano */
  height: 22px;
  border-radius: 4px;
}

  /* Pulse animation */
  @keyframes pulse {
    0% {
      box-shadow: 0 0 15px #ff9933;
    }
    50% {
      box-shadow: 0 0 25px #ffcc66, 0 0 40px #ff9933;
    }
    100% {
      box-shadow: 0 0 15px #ff9933;
    }
  }
</style>

<script>
const chanceBox = document.getElementById("chance-box");
const countdownBox = document.getElementById("countdown");

// Random Chance 80–98%
function generateRandomChance() {
  const chance = Math.floor(Math.random() * 19) + 80; // 80–98%
  chanceBox.innerText = `Chance: ${chance}%`;
}

// Timer synced with Bangladesh time (GMT+6)
function startBangladeshTimer() {
  let lastTimeLeft = 0;

  setInterval(() => {
    const now = new Date();
    const utc = now.getTime() + now.getTimezoneOffset() * 60000;
    const bdOffset = 6 * 60 * 60000;
    const bdTime = new Date(utc + bdOffset);

    const seconds = bdTime.getSeconds();
    const timeLeft = 30 - (seconds % 30); // 30 sec interval
    countdownBox.innerText = timeLeft;

    // Timer finished → refresh Chance once
    if(timeLeft === 30 && lastTimeLeft !== 30) {
      generateRandomChance();
    }

    lastTimeLeft = timeLeft;
  }, 1000);
}

// Page load e ekbar Chance generate
window.addEventListener("load", generateRandomChance);

startBangladeshTimer();
</script>


      <!-- Last 10 Signals -->
      <section class="card">
        <h3>Last 10 Results</h3>
        <table id="signals-table">
          <thead>
            <tr>
              <th>Hgnice Market Period</th>
              <th>Num</th>
              <th>B/S</th>
              <th>Color</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </section>
    </main>

    <footer class="footer">
      <p>&copy; 2025 Dev Raj | @tg71admin</p>
    </footer>
  </div>

<script>
const signalEl = document.getElementById("signal");
const periodEl = document.getElementById("period");
const countdownEl = document.getElementById("countdown");
const ring = document.querySelector(".timer-ring__progress");
const runningEl = document.getElementById("running-signal");

let countdownInterval;

// Convert current UTC time to Bangladesh time (UTC+6)
function getBangladeshTime() {
  const now = new Date();
  const utc = now.getTime() + (now.getTimezoneOffset() * 60000);
  const bangladeshTime = new Date(utc + (6 * 60 * 60 * 1000));
  return bangladeshTime;
}

// Fetch current period & signal
async function fetchCurrent() {
  try {
    const res = await fetch("signal.php?t=" + Date.now());
    const data = await res.json();

    if (data.status !== "success" || !data.result) {
      signalEl.textContent = "API Error";
      runningEl.textContent = "Running Now: Error";
      return;
    }

    const result = data.result;

    periodEl.textContent = `#${result.number1}`;
    signalEl.textContent = result.finalSignal;
    signalEl.className = "signal-text " + (result.finalSignal === "BIG" ? "signal-big" : "signal-small");
    runningEl.textContent = "Running Now: " + result.finalSignal;

    // Countdown logic: each period = 30s
    const periodDuration = 30;
    const bdt = getBangladeshTime();
    const seconds = bdt.getSeconds();
    const remaining = periodDuration - (seconds % periodDuration);

    startCountdown(remaining);
  } catch (e) {
    console.error(e);
    signalEl.textContent = "Connection Error";
    runningEl.textContent = "Running Now: Error";
  }
}

// Fetch last 10 signals
async function fetchLast10() {
  try {
    const res = await fetch("server.php?t=" + Date.now());
    const data = await res.json();
    const tbody = document.querySelector("#signals-table tbody");
    tbody.innerHTML = "";

    if (data.status === "success" && data.last10Signals) {
      data.last10Signals.forEach(sig => {
        const tr = document.createElement("tr");
        const bsClass = sig.marketSignal === "BIG" ? "big" : "small";
        tr.innerHTML = `
          <td>${sig.periodId}</td>
          <td>${sig.number}</td>
          <td class="${bsClass}">${sig.marketSignal}</td>
          <td>${sig.color}</td>
        `;
        tbody.appendChild(tr);
      });
    }
  } catch (e) {
    console.error("Last10 load error", e);
  }
}

// Countdown animation
function startCountdown(seconds) {
  clearInterval(countdownInterval);
  const radius = ring.r.baseVal.value;
  const circumference = 2 * Math.PI * radius;
  ring.style.strokeDasharray = `${circumference} ${circumference}`;

  let remaining = seconds;

  const update = () => {
    const progress = remaining / 30;
    const offset = circumference - progress * circumference;
    ring.style.strokeDashoffset = offset;
    countdownEl.textContent = remaining;

    if (remaining <= 0) {
      clearInterval(countdownInterval);
      fetchCurrent();
      fetchLast10();
    }
    remaining--;
  };
  update();
  countdownInterval = setInterval(update, 1000);
}

// Initial load
fetchCurrent();
fetchLast10();

// Refresh running signal every 5 sec
setInterval(fetchCurrent, 5000);
</script>
</body>
</html>
