<?php
header("Content-Type: application/json");

// ================== Chart Mapping (from your table) ==================
$chart = [
    1 => ["S","B","S","B","B","B","S","B","B"],  // ÷1
    2 => ["B","S","S","S","S","B","B","S","B"],  // ÷2
    3 => ["S","S","B","B","S","B","S","B","S"],  // ÷3
    4 => ["B","S","B","B","S","S","B","S","B"],  // ÷4
    5 => ["S","B","B","B","S","B","S","B","S"],  // ÷5
    6 => ["B","S","B","S","B","B","S","B","S"],  // ÷6
    7 => ["B","B","B","B","S","S","B","S","S"],  // ÷7
    8 => ["S","S","S","B","B","S","B","B","B"],  // ÷8
    9 => ["S","S","B","S","B","S","S","B","B"],  // ÷9
];

// ================== Function: Chart Lookup ==================
function getChartSignal($num, $den, $chart) {
    if ($num == 0) return "BIG"; // 0 হলে সবসময় BIG
    if (!isset($chart[$den])) return "N/A"; // invalid denominator
    if ($num > 9) $num = ($num % 9 == 0) ? 9 : $num % 9; // 1-9 এর মধ্যে রাখতে
    
    $result = $chart[$den][$num - 1];
    
    // ✅ এখানে mapping করা হচ্ছে
    if ($result === "S") {
        return "SMALL";
    } else {
        return "BIG";
    }
}

// ================== External API Call ==================
$apiUrl = "https://devraj.crazybook.my.id/market.php";
$response = file_get_contents($apiUrl);
$data = json_decode($response, true);

$output = [];

if ($data && isset($data['signals'])) {
    // প্রথম 2 টা নম্বর ধরা
    $num1 = intval($data['signals'][0]['number']);
    $num2 = intval($data['signals'][1]['number']);

    // চার্ট থেকে Final Signal
    $finalSignal = getChartSignal($num1, $num2, $chart);

    $output = [
        "number1" => $num1,
        "number2" => $num2,
        "finalSignal" => $finalSignal
    ];
}

// ================== Final Response ==================
echo json_encode([
    "status" => "success",
    "result" => $output,
    "developer" => "Dev By Raj",
    "telegram" => "@tg71admin"
], JSON_PRETTY_PRINT);

?>