<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=no">
<title>[𝗗𝗲𝘃 𝗥𝗮𝗷] Trading Dashboard</title>
<link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;700&family=Orbitron:wght@700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
:root {
  --bg-primary: #10141C;
  --bg-secondary: #191F2C;
  --border-color: #333A4C;
  --text-primary: #F0F2F5;
  --text-secondary: #7A8299;
  --aura-gold: #FFC700;
  --aura-teal: #00F5D4;
  --aura-red: #FF4D4D;
  --font-primary: 'DM Sans', sans-serif;
  --font-display: 'Orbitron', sans-serif;
}

/* Page Reset */
* { box-sizing:border-box; margin:0; padding:0; }
body, html { height:100%; width:100%; overflow:hidden; font-family: var(--font-primary); color: var(--text-primary); }

/* Webview Background */
#webview {
  position:fixed;
  top:0; left:0;
  width:100%; height:100%;
  border:none;
  z-index:0;
}

/* Logo Button */
#logoButton {
  position:fixed;
  top:15px; left:15px;
  z-index:150;
  display:flex;
  align-items:center;
  gap:0.5rem;
  background: rgba(0,0,0,0.5);
  padding:8px 12px;
  border-radius:12px;
  cursor:pointer;
  backdrop-filter: blur(5px);
  animation: neonGlow 2s infinite alternate;
}
#logoButton i {
  font-size:1.5rem;
  background: linear-gradient(45deg, var(--aura-gold), var(--aura-teal));
  -webkit-background-clip:text; -webkit-text-fill-color:transparent;
  animation: spin 3s linear infinite;
}
#logoButton h1 {
  font-family: var(--font-display);
  font-size:1rem;
  color: var(--aura-gold);
  animation: textShine 2s infinite alternate;
}
@keyframes spin { 0% {transform:rotate(0deg);} 100% {transform:rotate(360deg);} }
@keyframes textShine { from{ text-shadow:0 0 0 var(--aura-gold);} to{ text-shadow:0 0 10px var(--aura-gold);} }
@keyframes neonGlow { from{box-shadow:0 0 0 var(--aura-gold);} to{box-shadow:0 0 14px var(--aura-gold);} }

/* App Container (Popup Box) */
#popupBox {
  position:fixed;
  top:100px; left:100px;
  width:360px; height:520px;
  background: rgba(16,20,28,0.95);
  border:1px solid var(--border-color);
  border-radius:15px;
  overflow:auto;
  display:none;
  z-index:100;
  box-shadow:0 0 20px #0008;
  animation: fadeInBox 0.5s ease-in-out;
  cursor: move;
}
@keyframes fadeInBox { from {opacity:0; transform: scale(0.8);} to {opacity:1; transform: scale(1);} }

/* Header inside Box */
.header {
  display:flex; justify-content:center; align-items:center;
  padding:1rem;
  border-bottom:1px solid var(--border-color);
  text-align:center;
}

/* Card */
.card {
  background-color: var(--bg-secondary);
  border:1px solid var(--border-color);
  border-radius:12px;
  padding:1.5rem;
  position:relative;
  overflow:hidden;
  text-align:center;
  margin:1rem;
  transition:0.4s;
}
.card:hover { transform:translateY(-4px); box-shadow:0 0 12px var(--aura-teal);}
.card::before {
  content:'';
  position:absolute; top:0; left:0; right:0;
  height:2px;
  background: linear-gradient(90deg, transparent, var(--aura-gold), transparent);
  animation: scan 6s linear infinite;
}
@keyframes scan { 0% { transform: translateX(-100%);} 100% {transform: translateX(100%);} }

/* Running Signal */
.running-signal {
  font-size:1rem;
  font-weight:500;
  color: var(--aura-teal);
  margin-bottom:0.5rem;
  text-shadow:0 0 8px var(--aura-teal);
  animation: glowPulse 2s infinite;
}
@keyframes glowPulse { 0% { opacity:0.7;} 100% { opacity:1; text-shadow:0 0 15px var(--aura-teal); } }

/* Signal Text */
.signal-text {
  font-size:2rem;
  font-weight:bold;
  margin-top:0.5rem;
  animation: beat 1.2s infinite ease-in-out;
}
@keyframes beat { 0% { transform:scale(1);} 50% { transform:scale(1.12);} 100% { transform:scale(1); } }
.signal-big { color:var(--aura-red); text-shadow:0 0 12px var(--aura-red);}
.signal-small { color:var(--aura-teal); text-shadow:0 0 12px var(--aura-teal);}

/* Timer */
.timer-container { margin-top:1.5rem; position:relative; width:140px; height:140px; margin-left:auto; margin-right:auto;}
.timer-ring { transform:rotate(-90deg); filter: drop-shadow(0 0 6px var(--aura-gold));}
.timer-ring__background { stroke:var(--border-color); fill:transparent; stroke-width:6;}
.timer-ring__progress { stroke:var(--aura-gold); fill:transparent; stroke-width:6; stroke-linecap:round; transition: stroke-dashoffset 1s linear; filter: drop-shadow(0 0 4px var(--aura-gold)); }
.timer-text { position:absolute; top:50%; left:50%; transform:translate(-50%,-50%); font-family:var(--font-display); font-size:2rem; color:var(--aura-gold); }

/* Table */
table { width:100%; border-collapse:collapse; margin-top:1rem; font-size:0.8rem;}
th, td { padding:6px; text-align:center; border-bottom:1px solid var(--border-color);}
th { color:var(--aura-gold); font-weight:600;}
.big { color:var(--aura-red); font-weight:bold;}
.small { color:var(--aura-teal); font-weight:bold;}
</style>
</head>
<body>

<!-- Background Webview -->
<iframe id="webview" src="https://dkwin9.com"></iframe>

<!-- Logo Button -->
<div id="logoButton">
  <i class="fas fa-chart-line"></i>
  <h1>Trading Dashboard</h1>
</div>

<!-- Popup Box -->
<div id="popupBox">
 <header class="header">
      <div class="header-logo">
        <i class="fas fa-chart-line"></i>
        <h1>[𝗗𝗲𝘃 𝗥𝗮𝗷] 𝐎𝐟𝐟𝐢𝐜𝐢𝐚𝐥</h1>
      </div>
    </header>

    <main>
      <section class="card">
        <div id="running-signal" class="running-signal">Running Now: --</div>
        <h2>Dkwin Current Period: <span id="period">--</span></h2>
        <div id="signal" class="signal-text">Loading...</div>

        <!-- Timer -->
        <div class="timer-container">
          <svg class="timer-ring" width="140" height="140">
            <circle class="timer-ring__background" r="64" cx="70" cy="70" />
            <circle class="timer-ring__progress" r="64" cx="70" cy="70" />
          </svg>
          <div class="timer-text" id="countdown">--</div>
        </div>
        
        <script>
const signalEl = document.getElementById("signal");
const periodEl = document.getElementById("period");
const countdownEl = document.getElementById("countdown");
const ring = document.querySelector(".timer-ring__progress");
const runningEl = document.getElementById("running-signal");

let countdownInterval;

// Convert current UTC time to Bangladesh time (UTC+6)
function getBangladeshTime() {
  const now = new Date();
  const utc = now.getTime() + (now.getTimezoneOffset() * 60000);
  const bangladeshTime = new Date(utc + (6 * 60 * 60 * 1000));
  return bangladeshTime;
}

// Fetch current period & signal
async function fetchCurrent() {
  try {
    const res = await fetch("signal.php?t=" + Date.now());
    const data = await res.json();

    if (data.status !== "success" || !data.result) {
      signalEl.textContent = "API Error";
      runningEl.textContent = "Running Now: Error";
      return;
    }

    const result = data.result;

    periodEl.textContent = `#${result.number1}`;
    signalEl.textContent = result.finalSignal;
    signalEl.className = "signal-text " + (result.finalSignal === "BIG" ? "signal-big" : "signal-small");
    runningEl.textContent = "Running Now: " + result.finalSignal;

    // Countdown logic: each period = 30s
    const periodDuration = 30;
    const bdt = getBangladeshTime();
    const seconds = bdt.getSeconds();
    const remaining = periodDuration - (seconds % periodDuration);

    startCountdown(remaining);
  } catch (e) {
    console.error(e);
    signalEl.textContent = "Connection Error";
    runningEl.textContent = "Running Now: Error";
  }
}

// Fetch last 10 signals
async function fetchLast10() {
  try {
    const res = await fetch("server.php?t=" + Date.now());
    const data = await res.json();
    const tbody = document.querySelector("#signals-table tbody");
    tbody.innerHTML = "";

    if (data.status === "success" && data.last10Signals) {
      data.last10Signals.forEach(sig => {
        const tr = document.createElement("tr");
        const bsClass = sig.marketSignal === "BIG" ? "big" : "small";
        tr.innerHTML = `
          <td>${sig.periodId}</td>
          <td>${sig.number}</td>
          <td class="${bsClass}">${sig.marketSignal}</td>
          <td>${sig.color}</td>
        `;
        tbody.appendChild(tr);
      });
    }
  } catch (e) {
    console.error("Last10 load error", e);
  }
}

// Countdown animation
function startCountdown(seconds) {
  clearInterval(countdownInterval);
  const radius = ring.r.baseVal.value;
  const circumference = 2 * Math.PI * radius;
  ring.style.strokeDasharray = `${circumference} ${circumference}`;

  let remaining = seconds;

  const update = () => {
    const progress = remaining / 30;
    const offset = circumference - progress * circumference;
    ring.style.strokeDashoffset = offset;
    countdownEl.textContent = remaining;

    if (remaining <= 0) {
      clearInterval(countdownInterval);
      fetchCurrent();
      fetchLast10();
    }
    remaining--;
  };
  update();
  countdownInterval = setInterval(update, 1000);
}

// Initial load
fetchCurrent();
fetchLast10();

// Refresh running signal every 5 sec
setInterval(fetchCurrent, 5000);
</script>
</body>
</html>

<script>
// Dragable Box
dragElement(document.getElementById("popupBox"));
function dragElement(elmnt){
  var pos1=0,pos2=0,pos3=0,pos4=0;
  elmnt.onmousedown=dragMouseDown;
  function dragMouseDown(e){
    e=e||window.event; e.preventDefault();
    pos3=e.clientX; pos4=e.clientY;
    document.onmouseup=closeDragElement;
    document.onmousemove=elementDrag;
  }
  function elementDrag(e){
    e=e||window.event; e.preventDefault();
    pos1=pos3-e.clientX; pos2=pos4-e.clientY;
    pos3=e.clientX; pos4=e.clientY;
    elmnt.style.top=(elmnt.offsetTop-pos2)+"px";
    elmnt.style.left=(elmnt.offsetLeft-pos1)+"px";
  }
  function closeDragElement(){ document.onmouseup=null; document.onmousemove=null; }
}

// Logo Click Show/Hide Box
document.getElementById("logoButton").addEventListener("click", function(){
  var box=document.getElementById("popupBox");
  if(box.style.display==="block"){ box.style.display="none"; }
  else{ box.style.display="block"; }
});
</script>

</body>
</html>
