<?php
header("Content-Type: application/json");

// ================== Chart Mapping ==================
$chart = [
    1 => ["S","B","S","B","B","B","S","B","B"],  
    2 => ["B","S","S","S","S","B","B","S","B"],  
    3 => ["S","S","B","B","S","B","S","B","S"],  
    4 => ["B","S","B","B","S","S","B","S","B"],  
    5 => ["S","B","B","B","S","B","S","B","S"],  
    6 => ["B","S","B","S","B","B","S","B","S"],  
    7 => ["B","B","B","B","S","S","B","S","S"],  
    8 => ["S","S","S","B","B","S","B","B","B"],  
    9 => ["S","S","B","S","B","S","S","B","B"],  
];

// ================== Chart Function ==================
function getChartSignal($num, $den, $chart) {
    if ($num == 0) return "BIG";
    if (!isset($chart[$den])) return "N/A";
    if ($num > 9) $num = ($num % 9 == 0) ? 9 : $num % 9;
    return ($chart[$den][$num - 1] === "S") ? "SMALL" : "BIG";
}

// ================== Fetch signal2.php via cURL ==================
$apiUrl = "http://yourdomain.com/signal2.php"; // <-- full URL of signal2.php
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5);
$response = curl_exec($ch);
curl_close($ch);

if(!$response){
    echo json_encode([
        "status" => "error",
        "message" => "Failed to fetch signal2.php via cURL",
        "developer" => "Dev By Raj",
        "telegram" => "@tg71admin"
    ], JSON_PRETTY_PRINT);
    exit;
}

$data = json_decode($response, true);

$output = [];

// ================== Process Last Signals ==================
if($data && isset($data['lastSignals']) && count($data['lastSignals']) >= 2){
    // ignore latest, use next 2
    $signalsToUse = array_slice($data['lastSignals'], 1, 2);

    $num1 = intval($signalsToUse[0]['number']);
    $num2 = intval($signalsToUse[1]['number']);

    $finalSignal = getChartSignal($num1, $num2, $chart);

    $output = [
        "number1" => $num1,
        "number2" => $num2,
        "finalSignal" => $finalSignal
    ];
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Not enough signals available",
        "developer" => "Dev By Raj",
        "telegram" => "@tg71admin"
    ], JSON_PRETTY_PRINT);
    exit;
}

// ================== Final Response ==================
echo json_encode([
    "status" => "success",
    "result" => $output,
    "developer" => "Dev By Raj",
    "telegram" => "@tg71admin"
], JSON_PRETTY_PRINT);