<?php
header('Content-Type: application/json');

// Developer Info
$developer = "Dev By Raj";
$telegram = "@tg71admin";

// Time Zone
date_default_timezone_set("Asia/Dhaka");

// API URL
$historyUrl = "https://draw.ar-lottery01.com/WinGo/WinGo_30S/GetHistoryIssuePage.json?ts=" . round(microtime(true) * 1000);

// CURL Setup
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $historyUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 5,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false
]);
$response = curl_exec($ch);
curl_close($ch);

// If no response
if (!$response) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch data',
        'developer' => $developer,
        'telegram' => $telegram
    ]);
    exit;
}

// Decode JSON
$data = json_decode($response, true);
if (!isset($data['data']['list'][0])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'No data found',
        'developer' => $developer,
        'telegram' => $telegram
    ]);
    exit;
}

// Take last 10 results
$last10 = array_slice($data['data']['list'], 0, 10);

// Prepare Signals
$signals = [];
foreach ($last10 as $row) {
    $number = intval($row['number']);
    $period = $row['issueNumber'] ?? 'N/A';
    $color = $row['color'] ?? 'N/A';

    // Market signal logic
    if ($number > 4) {
        $market = "BIG";
    } elseif ($number < 5) {
        $market = "SMALL";
    } else {
        $market = "DRAW"; // For number 5
    }

    $signals[] = [
        'periodId' => $period,
        'number' => $number,
        'color' => $color,
        'marketSignal' => $market
    ];
}

// Countdown for next 30s draw
$secondsSinceMidnight = date('H') * 3600 + date('i') * 60 + date('s');
$countdown = 30 - ($secondsSinceMidnight % 30);

// Final Response
echo json_encode([
    'status' => 'success',
    'countdown' => $countdown,
    'timestamp' => date("Y-m-d H:i:s"),
    'developer' => $developer,
    'telegram' => $telegram,
    'last10Signals' => $signals
], JSON_PRETTY_PRINT);
?>
