<?php
header('Content-Type: application/json');

// Dev info
$developer = "Dev By Raj";
$telegram = "@tg71admin";

// Dhaka time setup
date_default_timezone_set("Asia/Dhaka");

// WinGo history URL
$historyUrl = "https://draw.ar-lottery01.com/WinGo/WinGo_30S/GetHistoryIssuePage.json?ts=" . round(microtime(true)*1000);

// Fetch data from WinGo
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $historyUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

if(!$response){
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch data',
        'developer' => $developer,
        'telegram' => $telegram
    ]);
    exit;
}

// Decode JSON
$data = json_decode($response, true);
if(!isset($data['data']['list'][2])){
    echo json_encode([
        'status' => 'error',
        'message' => 'Not enough signals found',
        'developer' => $developer,
        'telegram' => $telegram
    ]);
    exit;
}

// Get last 3 signals
$lastThree = array_slice($data['data']['list'], 0, 3);

// Ignore the first (latest) signal and keep the next 2
$signalsToShow = array_slice($lastThree, 1, 2);

$signals = [];
foreach($signalsToShow as $item){
    $premium = intval($item['premium']);
    $market = ($premium >= 6) ? "BIG" : "SMALL";

    $signals[] = [
        'periodId' => $item['issueNumber'],
        'number' => $item['number'],
        'color' => $item['color'],
        'premium' => $item['premium'],
        'marketSignal' => $market
    ];
}

// Calculate Dhaka timer countdown for next signal
$secondsSinceMidnight = date('H')*3600 + date('i')*60 + date('s');
$countdown = 30 - ($secondsSinceMidnight % 30);

// Prepare API response
$apiResponse = [
    'status' => 'success',
    'lastSignals' => $signals,
    'countdown' => $countdown,
    'timestamp' => time(),
    'developer' => $developer,
    'telegram' => $telegram
];

// Output JSON
echo json_encode($apiResponse, JSON_PRETTY_PRINT);